/*
This is an example program that finds E1432 modules in the VXI
mainframe.  It works on an HP715 with the MXI interface, HP - UX 9.0.
SICL must be installed on the system.

See the SICL manual:HP Part No.E2090 - 90005 for SICL infomation.


        Makefile
--------------------------------------------------------------------------
detect:		detect.o
	cc -o detect detect.o -lsicl

detect.o:	detect.c
        cc -Aa -c detect.c
--------------------------------------------------------------------------
*/

#include <stdio.h>
#include <stdlib.h>
#include <sicl.h>
#include <e1432.h>

int
main(void)
{
    INST    sicl_id;		/* Sicl id for the vxi bus */
    struct vxiinfo info;	/* Info about servants */
    int     lalist[255];	/* list of all cards */
    int     E1432list[15];	/* list of E1432s */
    int     i, status, numfound;

    /* open sicl interface */
    sicl_id = iopen("vxi");
    if (sicl_id == 0)
    {
	(void) printf("iopen failed\n");
	exit(1);
    }

    /* fill servant list, -1 for empty entries */
    status = ivxiservants(sicl_id, 255, lalist);
    if (status != 0)
    {
	(void) printf("ivxiservants returned %d\n", status);
	(void) iclose(sicl_id);
	exit(1);
    }

    /* show found devices */
    (void) printf("Devices at:");
    for (i = 0; lalist[i] >= 0; i++)
	(void) printf(" %d", lalist[i]);
    (void) printf("\n");

    /* check each board, copy any E1432s to E1432list */
    numfound = 0;
    for (i = 0; lalist[i] >= 0; i++)
    {
	status = ivxirminfo(sicl_id, lalist[i], &info);
	if (status != 0)
	{
	    (void) printf("ivxirminfo() returned %d for laddr %d\n",
			  status, lalist[i]);
	    continue;
	}

	if (info.man_id == E1432_MAN_ID &&
	    (unsigned long) info.model >= E1432_MODEL_CODE_MIN &&
	    (unsigned long) info.model <= E1432_MODEL_CODE_MAX)
	{
	    if (info.selftest == 0)
	    {
		(void) printf("E1432 FAILED self test at laddr %d\n",
			      lalist[i]);
		continue;
	    }
	    E1432list[numfound++] = lalist[i];
	}
    }

    /* Show found boards */
    if (numfound > 0)
    {
	(void) printf("Found %d E1432/33/34 Family module%s at:",
		      numfound, (numfound > 1 ? "s" : ""));
	for (i = 0; i < numfound; i++)
	    (void) printf(" %d", E1432list[i]);
	(void) printf("\n");
    }
    else
	(void) printf("No E1432 modules were found.\n");

    return 0;
}
